//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) The Optional Enum
//:
//: ## Task:
//:
//: Refactor the code below to use the short-form method of writing optionals.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// declare an array of optionals
let finalYearExamScores: [Optional<Int>] = [.some(75), .some(43), .none, .some(90), .some(87), .some(12), .none]

// sum all the scores together
var sumOfFinalYearExamScores = 0
finalYearExamScores.forEach { examResult in
    if case .some(let unwrappedTestScore) = examResult {
        sumOfFinalYearExamScores += unwrappedTestScore
    }
}

// print the final result
print("Final Year Score: \(sumOfFinalYearExamScores)")

